<?php
/* --------------------------------------------------------------
   FetchedAllTrackingCodes.php 2020-03-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Events;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCodes;

/**
 * Class FetchedAllTrackingCodes
 *
 * @package Gambio\Admin\TrackingCode\Events
 */
class FetchedAllTrackingCodes
{
    /**
     * @var TrackingCodes
     */
    private $trackingCodes;
    
    
    /**
     * FetchedAllTrackingCodesEvent constructor.
     *
     * @param TrackingCodes $trackingCodes
     */
    private function __construct(TrackingCodes $trackingCodes)
    {
        $this->trackingCodes = $trackingCodes;
    }
    
    
    /**
     * @param TrackingCodes $trackingCodes
     *
     * @return FetchedAllTrackingCodes
     */
    public static function create(TrackingCodes $trackingCodes): FetchedAllTrackingCodes
    {
        return new self($trackingCodes);
    }
    
    
    /**
     * @return TrackingCodes
     */
    public function trackingCodes(): TrackingCodes
    {
        return $this->trackingCodes;
    }
    
    
    /**
     * @param TrackingCodes $trackingCodes
     */
    public function replaceTrackingCodes(TrackingCodes $trackingCodes): void
    {
        $this->trackingCodes = $trackingCodes;
    }
}